# Manus Prompt：构建个人投资组合管理与AI投资顾问系统

## 使用说明

将以下prompt复制到Manus对话中，根据您的实际情况修改`[占位符]`部分的内容。

---

## 完整Prompt

```
请帮我构建一个个人投资组合管理系统，具有以下功能和要求：

## 一、项目基本信息

项目名称：[您的项目名称，如"过程即奖励的持仓"]
项目slogan：[您的投资理念，如"过程即奖励，找到那把属于自己的剑"]

## 二、数据源配置

我已经有一个Supabase数据库，包含以下表：

1. **transactions表**（交易记录）
   - ticker: 股票代码（如 03690, AAPL, 600519）
   - name: 股票名称
   - action: 交易类型（BUY/SELL/SHORT/COVER/DEPOSIT/WITHDRAW）
   - price: 成交价格
   - quantity: 成交数量
   - currency: 货币类型（CNY/USD/HKD）
   - strategyNote: 交易理由
   - createdAt: 交易时间

2. **watchlist表**（关注列表）
   - ticker: 股票代码
   - name: 股票名称
   - market: 市场（HK/US/CN）

3. **market_cache表**（价格缓存）
   - ticker: 股票代码
   - price: 最新价格
   - updatedAt: 更新时间

4. **asset_snapshots表**（资产快照）
   - date: 日期
   - net_worth: 净值
   - cash_ratio: 现金比例
   - long_ratio: 多头比例
   - short_ratio: 空头比例

请使用以下Supabase连接信息：
- URL: [您的Supabase URL]
- Anon Key: [您的Supabase Anon Key]

## 三、核心功能需求

### 3.1 持仓概览页面

1. **持仓列表**
   - 显示所有当前持仓股票
   - 每只股票显示：股票名称、代码、成本价、现价、盈亏比例、持仓权重
   - 支持按盈亏比例或权重排序
   - 响应式设计，适配PC和手机

2. **资产配置图表**
   - 饼图或环形图展示现金/多头/空头比例
   - 使用柔和的配色方案

3. **业绩走势图**
   - 归一化净值曲线（基准值=100）
   - 显示累计收益率和最大回撤
   - 使用时间加权收益率（TWR）计算，排除出入金影响

4. **隐私保护**
   - 所有数字只显示比例和百分比
   - 不显示任何绝对金额

### 3.2 投资笔记功能

1. **笔记创建**
   - 密码保护的创建入口（密码：[您的密码]）
   - 自动生成标题：日期 + "投资memo"
   - 支持Markdown格式

2. **持仓快照**
   - 创建笔记时自动附加当天的持仓列表和资产配置
   - 快照数据从asset_snapshots表获取历史数据

3. **笔记列表**
   - 双栏卡片布局（类似小红书风格）
   - 显示标题、创建日期、内容预览

4. **笔记详情**
   - 完整展示笔记内容
   - 显示创建时的持仓快照

### 3.3 AI交易分析功能（投资照镜子）

1. **每日自动分析**
   - 每天早上9:15自动分析前一天的交易
   - 排除出金/入金，只分析实际股票交易
   - 在分析prompt中包含交易理由（strategyNote字段）

2. **AI投资顾问集成**
   - 调用外部AI投资顾问项目进行分析
   - 投资顾问项目ID：[您的PIP项目ID]
   - 分析维度：交易合理性、与投资原则一致性、交易理由评估、风险提示、改进建议

3. **分析结果展示**
   - 双栏卡片布局展示历史分析
   - 详情页显示完整分析内容
   - 引用来源默认折叠，点击可展开
   - 密码保护访问（密码：[您的密码]）

4. **追问对话功能**
   - 在分析详情页底部添加输入框
   - 可以基于当前分析内容追问投资顾问
   - 对话历史保存到数据库

### 3.4 每日提醒系统

1. **持仓波动提醒**（9:15 AM）
   - 检测涨跌幅超过5%的持仓股票
   - 获取相关新闻和公告
   - 通过邮件发送提醒

2. **交易分析报告**（9:15 AM）
   - 发送昨日交易的AI分析报告
   - 包含完整分析内容和引用来源

### 3.5 自动化定时任务

1. **价格更新**（7:00 AM北京时间）
   - 获取所有持仓股票的最新价格
   - 港股使用Manus数据API + 腾讯财经API备用
   - 美股和A股使用相应的数据源

2. **净值计算**（7:00 AM北京时间）
   - 计算当日净值并保存到asset_snapshots表
   - 计算现金/多头/空头比例

3. **备用任务**（9:00 AM北京时间）
   - 如果7:00任务失败，使用缓存数据重试

## 四、数据保护机制

1. **价格校验**
   - 单只股票价格变化超过95%时拒绝写入
   - 首次价格必须在0.01-100000范围内

2. **汇率校验**
   - USD/CNY必须在5-10之间
   - HKD/CNY必须在0.7-1.2之间
   - 汇率变化超过20%时拒绝更新

3. **净值校验**
   - 净值变化超过95%时拒绝保存快照

## 五、设计要求

1. **视觉风格**
   - 北欧极简主义
   - 浅灰色背景
   - 黑色无衬线字体
   - 柔和的蓝粉色点缀
   - 充足的留白空间

2. **响应式设计**
   - 适配PC和手机
   - 手机端股票名称可换行显示

3. **中文界面**
   - 所有UI文本使用中文

## 六、技术栈偏好

- 前端：React + Tailwind CSS + shadcn/ui
- 后端：Express + tRPC
- 数据库：Supabase
- 定时任务：Node.js Cron

## 七、需要创建的数据库表

除了已有的表，还需要创建：

1. **investment_memos表**（投资笔记）
   - id, title, content, holdingsSnapshot, createdAt

2. **trade_analysis_logs表**（交易分析记录）
   - id, date, tradesSummary, analysisResult, citations, createdAt

3. **diagnosis_conversations表**（追问对话）
   - id, analysisId, userMessage, assistantMessage, createdAt

4. **scheduler_logs表**（定时任务日志）
   - id, taskName, status, details, createdAt

请开始构建这个项目。
```

---

## 分阶段Prompt（推荐）

如果一次性prompt太长，可以分阶段进行：

### 阶段一：基础框架

```
请帮我创建一个个人投资组合管理系统。

项目名称：[您的项目名称]

需要连接Supabase数据库，包含transactions、watchlist、market_cache、asset_snapshots表。

第一阶段先实现：
1. 持仓概览页面（持仓列表、资产配置图、业绩走势图）
2. 所有数字只显示比例，不显示绝对金额
3. 北欧极简设计风格
4. 中文界面

Supabase连接信息：
- URL: [您的URL]
- Key: [您的Key]
```

### 阶段二：投资笔记

```
在现有项目基础上，添加投资笔记功能：

1. 创建investment_memos表
2. 密码保护的笔记创建（密码：[您的密码]）
3. 创建时自动附加持仓快照
4. 双栏卡片布局的笔记列表
5. 笔记详情页
```

### 阶段三：定时任务

```
添加自动化定时任务：

1. 每天7:00 AM获取最新股价并计算净值
2. 每天9:00 AM备用任务（如果7点失败）
3. 添加数据校验（价格变化>95%拒绝，汇率异常拒绝）
4. 创建scheduler_logs表记录任务执行情况
```

### 阶段四：AI交易分析

```
添加AI交易分析功能（投资照镜子）：

1. 每天9:15 AM分析前一天的交易
2. 调用外部AI投资顾问项目（项目ID：[您的PIP项目ID]）
3. 分析时包含交易理由（strategyNote字段）
4. 排除出金/入金，只分析实际交易
5. 创建trade_analysis_logs表保存分析结果
6. 通过邮件发送分析报告
7. 创建分析历史页面，密码保护访问
```

### 阶段五：追问对话

```
在交易分析详情页添加追问功能：

1. 创建diagnosis_conversations表
2. 在详情页底部添加输入框
3. 基于当前分析内容作为上下文，调用AI投资顾问
4. 对话历史保存到数据库
5. 以聊天气泡形式展示对话
```

---

## 关键配置项清单

在使用prompt之前，请准备好以下信息：

| 配置项 | 说明 | 示例 |
|--------|------|------|
| Supabase URL | 数据库连接地址 | https://xxx.supabase.co |
| Supabase Anon Key | 数据库访问密钥 | eyJhbGciOiJIUzI1NiIs... |
| 笔记密码 | 创建/删除笔记的密码 | yourpassword123 |
| 分析页密码 | 访问AI分析页面的密码 | anotherpassword456 |
| PIP项目ID | AI投资顾问项目的ID | pip_xxx |
| 项目名称 | 显示在页面上的名称 | 过程即奖励的持仓 |
| 项目slogan | 页面底部的签名 | 过程即奖励，找到那把属于自己的剑 |

---

## 注意事项

1. **数据库表结构**：确保您的Supabase表结构与prompt中描述的一致，否则需要调整字段名称。

2. **AI投资顾问**：需要先创建一个独立的AI投资顾问项目，上传您的投资笔记和播客内容作为知识库。

3. **定时任务时区**：所有时间均为北京时间（UTC+8）。

4. **隐私保护**：系统设计为只显示比例，如果您需要显示绝对金额，需要明确告知Manus修改这一约束。

5. **分阶段构建**：建议使用分阶段prompt，每个阶段完成后测试确认再进行下一阶段，这样更容易排查问题。
