# 投资镜子 (PIP - Personalized Investment Partner)

## 项目概述

**投资镜子**是一个基于AI的个性化投资决策助手系统，通过整合用户的投资哲学、历史经验和专业知识库，为投资者提供辩论式的、有据可查的投资建议。系统不仅给出建议，更重要的是挑战用户的假设，帮助识别投资决策中的潜在盲点。

## 核心理念

- **个性化**: 基于用户的性格画像、投资哲学和历史经验提供定制化建议
- **辩证思维**: 采用辩论式反馈，主动挑战用户假设，指出潜在风险
- **有据可查**: 每个观点都附带详细引用来源，确保建议的可追溯性
- **知识整合**: 融合专业投资理论、市场观点和个人经验的多维度分析

---

## 功能模块

### 1. 智能对话系统

#### 核心功能
- **实时投资咨询**: 用户可以就任何投资问题与AI进行深度对话
- **上下文记忆**: 系统记录完整的对话历史，保持对话连贯性
- **多对话管理**: 支持创建和管理多个独立的投资讨论主题
- **流式响应**: AI回答实时流式输出，提供流畅的交互体验

#### 技术特点
- 使用 **Google Gemini 3 Pro Preview** 作为核心AI模型
- 支持 **Markdown** 格式渲染，包括代码块、表格、列表等
- 响应式设计，完美适配桌面和移动设备

#### 对话示例
```
用户: "如何看待AI投资机会？"

AI: "你好。作为你的个性化投资伙伴（PIP），我听到了你关于AI投资的问题。
基于[风和亚洲投资哲学]中提到的'不要在市场高点追涨'原则，以及你的
[性格画像]中显示的'容易冲动'特质，我必须提醒你..."
```

---

### 2. 多源知识库 (RAG系统)

系统整合了**4个独立的知识源**，通过RAG (Retrieval-Augmented Generation) 技术为AI提供丰富的上下文：

#### 知识源详情

| 知识库 | 内容描述 | 用途 |
|--------|----------|------|
| **风和亚洲投资哲学** | 专业投资基金的投资原则和方法论 | 提供理论框架和长期投资智慧 |
| **播客转录** | 投资相关播客的讨论和见解 | 提供实时市场观点和案例分析 |
| **投资笔记** | 用户的历史投资经验和反思 | 提供个人教训和经验总结 |
| **动态笔记** | 用户实时创建的投资记录 | 提供最新的投资思考 |

#### 检索机制
- **并行查询**: 同时查询所有知识库，确保全面性
- **智能排序**: 根据相关性分数返回最相关的内容片段
- **实时更新**: 动态笔记实时同步到检索系统

#### 引用展示
每个AI回答都附带详细的引用来源：
- 引用原文的完整片段
- 来源名称（如：风和亚洲投资哲学、播客转录等）
- 文件名和页码信息
- 可折叠/展开的引用列表，方便查阅

---

### 3. 个性化用户档案

#### 档案内容
- **性格画像**: 用户的投资性格特征（如：风险偏好、决策风格）
- **投资哲学**: 用户的核心投资原则和信念
- **历史经验**: 过往的投资成功和失败案例
- **认知偏差**: 用户容易犯的投资错误

#### 档案功能
- **查看模式**: 以清晰的格式展示完整档案内容
- **编辑模式**: 随时更新和完善个人档案
- **智能应用**: AI在回答时自动引用档案中的相关信息

#### 个性化效果
系统会根据用户档案：
- 识别与用户投资哲学的冲突
- 提醒用户过往的类似错误
- 针对用户的认知偏差提供警示
- 基于用户风险偏好调整建议力度

---

### 4. 动态笔记管理

#### 笔记功能
- **创建笔记**: 随时记录投资想法、市场观察、决策过程
- **编辑笔记**: 更新和完善已有笔记内容
- **删除笔记**: 移除不再需要的笔记
- **标签系统**: 为笔记添加标签，方便分类和检索

#### 笔记特点
- **实时检索**: 笔记内容自动成为知识库的一部分
- **上下文引用**: AI可以引用用户的笔记内容
- **持久化存储**: 所有笔记安全存储在数据库中
- **全文搜索**: 支持基于关键词的智能检索

#### 使用场景
- 记录投资决策的思考过程
- 保存市场观察和分析
- 总结投资经验和教训
- 追踪特定股票或行业的研究

---

### 5. 外部API接口

系统提供完整的REST API，允许第三方应用集成投资咨询功能。

#### API特性
- **功能完整**: API返回的内容与网页版完全一致
- **安全认证**: 使用API Key进行身份验证
- **完整引用**: 返回AI回答和所有引用来源
- **易于集成**: 支持cURL、Python、JavaScript等多种调用方式

#### API端点

**1. 投资咨询**
```
POST /api/external/chat
Authorization: Bearer YOUR_API_KEY
Content-Type: application/json

{
  "message": "你的投资问题"
}
```

**响应格式**
```json
{
  "answer": "AI的完整回答，包含内联引用...",
  "citations": [
    {
      "source": "来源名称",
      "text": "引用原文",
      "metadata": {
        "file_name": "文件名",
        "page_label": "页码"
      }
    }
  ]
}
```

**2. 健康检查**
```
GET /api/external/health
```

#### 使用场景
- **移动应用集成**: 在iOS/Android应用中调用投资咨询功能
- **自动化工具**: 构建投资决策自动化流程
- **数据分析**: 批量处理投资问题，进行系统性分析
- **第三方平台**: 在其他投资平台中嵌入AI咨询功能

---

## 技术架构

### 前端技术栈
- **React 19**: 现代化的用户界面框架
- **Tailwind CSS 4**: 响应式设计和莫兰迪配色方案
- **tRPC**: 类型安全的API调用
- **Wouter**: 轻量级路由管理
- **Streamdown**: Markdown实时渲染

### 后端技术栈
- **Node.js + Express**: 服务器框架
- **tRPC 11**: 端到端类型安全的API
- **Drizzle ORM**: 类型安全的数据库操作
- **MySQL/TiDB**: 关系型数据库
- **Google Gemini API**: AI模型服务
- **LlamaIndex Cloud**: RAG知识库服务

### 核心技术
- **RAG (Retrieval-Augmented Generation)**: 知识增强生成
- **多源并行检索**: 同时查询多个知识库
- **流式响应**: 实时输出AI回答
- **API Key认证**: SHA-256哈希安全存储

---

## 数据安全

### 认证机制
- **API Key管理**: 支持生成、验证和撤销API Key
- **哈希存储**: API Key使用SHA-256哈希存储，不保存明文
- **Bearer Token**: 标准的HTTP认证方式

### 数据隐私
- **本地存储**: 用户档案和笔记存储在独立数据库
- **访问控制**: 每个用户只能访问自己的数据
- **安全传输**: 所有通信使用HTTPS加密

---

## 设计理念

### 用户体验
- **莫兰迪配色**: 柔和、专业的视觉风格
- **响应式设计**: 完美适配桌面、平板和手机
- **流畅交互**: 平滑的过渡动画和加载状态
- **清晰层次**: 使用阴影、边框和背景模糊建立视觉层次

### 交互设计
- **对话式界面**: 自然的聊天体验
- **实时反馈**: 即时显示AI思考过程
- **引用展示**: 可折叠的引用列表，不干扰阅读
- **移动优化**: 针对移动设备的触控优化

---

## 应用场景

### 个人投资者
- 在做出投资决策前，获取基于个人情况的分析
- 检验投资想法是否与自己的投资哲学一致
- 识别决策中的认知偏差和情绪影响
- 记录和回顾投资经验，持续改进

### 专业投资者
- 快速检索历史投资案例和市场观点
- 进行投资决策的压力测试
- 管理和组织投资研究笔记
- 通过API集成到现有投资工具链

### 投资顾问
- 为客户提供个性化的投资建议
- 基于客户档案进行风险评估
- 引用专业知识库支持建议
- 记录客户咨询历史和决策过程

### 投资教育
- 学习专业投资理论和方法论
- 通过案例分析理解投资原则
- 培养辩证思维和风险意识
- 建立个人投资知识体系

---

## 核心优势

### 1. 真正的个性化
不是通用的投资建议，而是基于**你的**性格、**你的**经验、**你的**哲学的定制化分析。

### 2. 辩证式反馈
不是简单的"买"或"卖"建议，而是挑战你的假设，帮助你看到盲点。

### 3. 有据可查
每个观点都有明确的引用来源，可以追溯到具体的理论、案例或经验。

### 4. 知识整合
融合专业理论（风和亚洲）、市场观点（播客）和个人经验（笔记）的多维度分析。

### 5. 持续学习
通过动态笔记功能，系统会随着你的投资经验不断进化和完善。

### 6. 灵活集成
通过API接口，可以轻松集成到各种投资工具和工作流程中。

---

## 技术亮点

### 1. 多源RAG架构
- 并行查询4个独立知识库
- 智能相关性排序
- 实时动态笔记检索

### 2. 端到端类型安全
- 使用tRPC实现前后端类型共享
- 编译时类型检查，减少运行时错误
- 自动生成API文档

### 3. 流式响应
- AI回答实时流式输出
- 提供即时反馈，改善用户体验
- 支持长文本生成

### 4. 安全的API认证
- API Key哈希存储
- Bearer Token标准认证
- 自动更新使用时间戳

### 5. 响应式设计
- 移动优先设计理念
- 完美适配各种屏幕尺寸
- 触控优化的交互体验

---

## 未来规划

### 短期目标
- [ ] API Key管理界面（用户自助生成和管理）
- [ ] 使用统计和分析（API调用次数、热门问题）
- [ ] 速率限制（防止API滥用）

### 中期目标
- [ ] 对话搜索功能（快速查找历史对话）
- [ ] 对话管理（重命名、删除、导出）
- [ ] 笔记标签系统增强（标签云、智能推荐）
- [ ] 投资组合跟踪（记录持仓和收益）

### 长期目标
- [ ] 多用户支持（团队协作功能）
- [ ] 高级数据分析（投资决策模式分析）
- [ ] 移动应用（iOS/Android原生应用）
- [ ] 社区功能（分享投资见解和经验）

---

## 总结

**投资镜子**不仅仅是一个AI聊天工具，而是一个完整的个性化投资决策支持系统。它通过整合专业知识、市场观点和个人经验，帮助投资者做出更理性、更符合自身情况的投资决策。

系统的核心价值在于：
1. **个性化**: 基于用户独特的投资哲学和经验
2. **辩证性**: 挑战假设，识别盲点
3. **可追溯**: 每个建议都有明确的引用来源
4. **可扩展**: 通过API支持各种集成场景

无论是个人投资者、专业投资者还是投资顾问，都可以从这个系统中获得价值，提升投资决策的质量。
