# Manus 快速构建指南 - 投资镜子项目

## 完整的 Manus Prompt

将以下内容直接发送给 Manus，即可快速构建一个完整的投资镜子项目：

---

```
请帮我构建一个名为"投资镜子"的个性化投资决策助手系统。

## 项目需求

### 1. 基础设置
- 项目名称：投资镜子 (Personalized Investment Partner)
- 使用 web-db-user 模板
- 配色方案：莫兰迪色系（柔和、专业）
- 主题：light 模式
- 移除所有登录认证功能，使用硬编码的用户ID（userId = 1）

### 2. 数据库设计

需要以下数据表：

**conversations 表**（对话）
- id: 自增主键
- userId: 用户ID
- title: 对话标题（varchar 255）
- createdAt: 创建时间
- updatedAt: 更新时间

**messages 表**（消息）
- id: 自增主键
- conversationId: 对话ID
- role: 枚举类型（user, assistant, system）
- content: 消息内容（text）
- citations: 引用来源（text，存储JSON字符串）
- createdAt: 创建时间

**userProfiles 表**（用户档案）
- id: 自增主键
- userId: 用户ID（唯一）
- profileContent: 档案内容（text）
- investmentPhilosophy: 投资哲学（text）
- createdAt: 创建时间
- updatedAt: 更新时间

**dynamicNotes 表**（动态笔记）
- id: 自增主键
- userId: 用户ID
- title: 笔记标题（varchar 255）
- content: 笔记内容（text）
- tags: 标签（varchar 500，逗号分隔）
- createdAt: 创建时间
- updatedAt: 更新时间

**apiKeys 表**（API密钥）
- id: 自增主键
- userId: 用户ID
- keyHash: 密钥哈希（varchar 64，唯一）
- keyPrefix: 密钥前缀（varchar 8）
- name: 密钥名称（varchar 255）
- lastUsedAt: 最后使用时间
- createdAt: 创建时间

### 3. 核心功能模块

#### 3.1 智能对话系统
- 创建 Chat 页面（/chat 和 /chat/:id 路由）
- 左侧边栏显示对话列表，支持创建新对话
- 右侧主区域显示消息历史和输入框
- 消息支持 Markdown 渲染（使用 streamdown 库）
- 每条 AI 回答下方显示可折叠的引用来源列表
- 响应式设计，移动端侧边栏可收起

#### 3.2 LlamaIndex RAG 集成
创建 `server/llamaindex.ts` 文件，集成以下 RAG 数据源：

```typescript
export const RAG_SOURCES = {
  fenghe: {
    name: "风和亚洲投资哲学",
    endpoint: "https://api.cloud.llamaindex.ai/api/v1/pipelines/[PIPELINE_ID]/retrieve",
    description: "风和亚洲基金的投资哲学和原则"
  },
  podcasts: {
    name: "播客转录",
    endpoint: "https://api.cloud.llamaindex.ai/api/v1/pipelines/[PIPELINE_ID]/retrieve",
    description: "投资相关播客讨论和见解"
  },
  notes: {
    name: "投资笔记",
    endpoint: "https://api.cloud.llamaindex.ai/api/v1/pipelines/[PIPELINE_ID]/retrieve",
    description: "个人投资经验和反思"
  },
  dynamicNotes: {
    name: "动态笔记",
    endpoint: "local",
    description: "系统中创建的实时投资笔记"
  }
};
```

实现以下函数：
- `queryRAGSource()`: 查询单个 RAG 源
- `queryAllRAGSources()`: 并行查询所有 RAG 源
- `formatRAGResultsForLLM()`: 格式化 RAG 结果为 LLM 上下文
- `extractCitations()`: 提取引用信息

对于 dynamicNotes，实现本地数据库检索，使用简单的关键词匹配评分。

#### 3.3 Google Gemini 集成
创建 `server/gemini.ts` 文件：
- 使用 Gemini 3 Pro Preview 模型
- 实现 `callGemini()` 函数
- 支持 system、user、assistant 角色
- 配置参数：temperature=0.7, topK=40, topP=0.95, maxOutputTokens=8192

需要添加环境变量：GEMINI_API_KEY

#### 3.4 Chat Router 实现
在 `server/routers.ts` 中实现 chat.send 接口：

1. 保存用户消息到数据库
2. 获取用户档案（profileContent）
3. 调用 `queryAllRAGSources()` 查询所有知识库（每个返回 top 3）
4. 构建系统提示词：
   - 说明 AI 是个性化投资助手（PIP）
   - 包含用户档案内容
   - 包含 RAG 检索结果
   - 强调必须使用内联引用格式（如：[风和亚洲投资哲学-第X章]）
   - 要求辩论式反馈，挑战假设
5. 调用 Gemini API 生成回答
6. 保存 AI 消息和引用到数据库
7. 如果是第一次对话，更新对话标题（取用户消息前50字符）
8. 返回回答和引用

#### 3.5 用户档案页面
创建 Profile 页面（/profile 路由）：
- 显示完整的用户档案内容
- 支持查看/编辑模式切换
- 编辑模式使用 textarea，保存后更新数据库
- 使用卡片式布局，清晰展示档案信息

#### 3.6 动态笔记页面
创建 Notes 页面（/notes 路由）：
- 显示所有笔记列表
- 支持创建、编辑、删除笔记
- 笔记包含标题、内容、标签
- 使用卡片式布局展示笔记
- 添加"新建笔记"按钮

#### 3.7 外部 API 接口
创建 `server/api-endpoint.ts` 文件：

实现以下端点：
- `POST /api/external/chat`: 投资咨询接口
  - 需要 Bearer Token 认证
  - 请求体：`{ "message": "问题" }`
  - 返回：`{ "answer": "回答", "citations": [...] }`
- `GET /api/external/health`: 健康检查

创建 `server/apikey.ts` 文件实现：
- `generateApiKey()`: 生成格式为 `pip_[48位十六进制]` 的密钥
- `hashApiKey()`: 使用 SHA-256 哈希
- `createApiKey()`: 创建并存储 API 密钥
- `verifyApiKey()`: 验证密钥并返回用户ID
- `listApiKeys()`: 列出用户的所有密钥
- `deleteApiKey()`: 删除密钥

在 `server/_core/index.ts` 中注册路由：
```typescript
app.use("/api/external", apiRouter);
```

创建脚本 `scripts/generate-apikey.mjs` 用于生成 API 密钥。

### 4. UI/UX 设计要求

#### 4.1 配色方案（莫兰迪色系）
在 `client/src/index.css` 中定义：
- 主色调：柔和的青色（#5A9A9A）
- 背景色：浅灰白色（#F5F5F5）
- 文字色：深灰色（#333333）
- 边框色：浅灰色（#E0E0E0）
- 使用柔和的阴影和圆角

#### 4.2 Chat 页面布局
- 桌面端：左侧边栏（300px）+ 右侧主区域
- 移动端：全屏主区域，侧边栏可滑出
- 侧边栏顶部：应用标题 + 新建对话按钮
- 侧边栏内容：对话列表（显示标题和图标）
- 主区域顶部：页面标题 + 笔记按钮
- 主区域中间：消息列表（自动滚动到底部）
- 主区域底部：输入框 + 发送按钮

#### 4.3 消息样式
- 用户消息：右对齐，蓝色背景
- AI 消息：左对齐，白色背景，带阴影
- 引用区域：可折叠，灰色背景，带图标
- 每个引用显示：来源名称 + 原文片段 + 元数据

#### 4.4 响应式设计
- 使用 Tailwind 的响应式类（sm:, md:, lg:）
- 移动端优化触控交互
- 确保所有功能在移动端可用

### 5. 路由配置

在 `client/src/App.tsx` 中配置：
```tsx
<Route path="/" component={Home} />
<Route path="/chat" component={Chat} />
<Route path="/chat/:id" component={Chat} />
<Route path="/profile" component={Profile} />
<Route path="/notes" component={Notes} />
```

### 6. 环境变量

需要配置以下环境变量：
- `GEMINI_API_KEY`: Google Gemini API 密钥
- `LLAMAINDEX_API_KEY`: LlamaIndex Cloud API 密钥
- `DATABASE_URL`: 数据库连接字符串（自动配置）

### 7. 测试要求

创建以下测试文件：
- `server/llamaindex.test.ts`: 测试 RAG 查询功能
- `server/gemini.test.ts`: 测试 Gemini API 调用
- `server/api-endpoint.test.ts`: 测试 API 密钥管理
- `server/auth.logout.test.ts`: 测试登出功能（保留模板示例）

确保所有测试通过后再交付。

### 8. 文档

创建以下文档：
- `API_DOCUMENTATION.md`: 详细的 API 使用文档
  - 包含端点说明
  - 请求/响应示例
  - cURL、Python、JavaScript 调用示例
  - 错误码说明
- `PROJECT_INTRODUCTION.md`: 项目介绍文档
  - 功能模块说明
  - 技术架构
  - 应用场景
  - 核心优势

### 9. 实现步骤

请按以下顺序实现：

1. 初始化项目，创建数据库表
2. 实现 LlamaIndex RAG 集成
3. 实现 Gemini API 集成
4. 实现 Chat 功能（后端 + 前端）
5. 实现 Profile 页面
6. 实现 Notes 页面
7. 实现外部 API 接口
8. 优化 UI/UX（配色、响应式、动画）
9. 编写测试并确保通过
10. 创建文档
11. 创建 checkpoint

### 10. 注意事项

- 所有用户相关操作使用硬编码的 userId = 1
- 移除所有登录/认证相关的 UI 和逻辑
- 确保移动端体验流畅
- 引用来源必须可折叠，不影响阅读体验
- API 密钥必须使用哈希存储，不保存明文
- 所有 AI 回答必须包含内联引用
- 系统提示词要强调辩论式反馈和挑战假设

完成后，请：
1. 运行所有测试确保通过
2. 在浏览器中测试所有功能
3. 生成一个 API 密钥并测试外部 API
4. 创建 checkpoint
5. 提供项目访问链接和 API 密钥
```

---

## 使用说明

1. 将上述 prompt 复制到 Manus 对话框
2. 等待 Manus 完成项目构建
3. 根据提示配置环境变量（GEMINI_API_KEY、LLAMAINDEX_API_KEY）
4. 上传用户档案文件（如果有）
5. 测试所有功能
6. 发布项目

## 预计时间

- 项目初始化和数据库设计：10-15 分钟
- 后端功能实现：20-30 分钟
- 前端页面开发：20-30 分钟
- UI 优化和测试：10-15 分钟
- 文档编写：5-10 分钟

**总计：约 60-90 分钟**

## 需要准备的资源

1. **Google Gemini API Key**: 
   - 访问 https://makersuite.google.com/app/apikey
   - 创建新的 API 密钥

2. **LlamaIndex Cloud API Key**:
   - 访问 https://cloud.llamaindex.ai
   - 创建账号并获取 API 密钥
   - 创建 3 个 Pipeline 并上传知识库文件
   - 记录每个 Pipeline 的 ID

3. **用户档案文件**（可选）:
   - 准备一个包含投资哲学、性格画像的文本文件
   - 格式可以是纯文本或 Markdown

## 关键差异点

如果您想要定制化，可以修改 prompt 中的以下部分：

- **配色方案**: 修改"配色方案"部分的颜色值
- **AI 模型**: 修改 Gemini 模型版本
- **RAG 数据源**: 修改 RAG_SOURCES 的数量和类型
- **系统提示词**: 调整 AI 的回答风格和要求
- **功能模块**: 添加或删除特定功能

## 故障排查

如果构建过程中遇到问题：

1. **RAG 查询失败**: 检查 LLAMAINDEX_API_KEY 是否正确，Pipeline ID 是否有效
2. **Gemini API 错误**: 检查 GEMINI_API_KEY 是否正确，配额是否充足
3. **数据库错误**: 确保已运行 `pnpm db:push` 推送数据库变更
4. **UI 显示问题**: 检查是否已切换到 light 主题，Morandi 颜色是否正确应用

## 后续优化建议

构建完成后，可以考虑以下优化：

1. 添加 API Key 管理界面（用户自助生成和管理）
2. 实现对话搜索功能
3. 添加投资组合跟踪功能
4. 实现数据导出功能
5. 添加使用统计和分析
