# 过程即奖励的持仓 - 个人投资管理系统

> "过程即奖励，找到那把属于自己的剑"

## 项目概述

这是一个**个人投资组合管理与AI投资顾问系统**，专为认真对待投资的个人投资者设计。系统不仅提供传统的持仓管理和业绩追踪功能，更创新性地集成了**AI投资顾问**，能够基于您的投资笔记、播客内容和历史交易记录，对每一笔交易进行个性化的分析和反馈。

系统采用**隐私优先**的设计理念，所有展示均使用比例和百分比，不暴露任何绝对金额。

---

## 核心功能模块

### 一、持仓概览（Portfolio Dashboard）

**实时持仓管理**，让您随时掌握投资组合的全貌。

| 功能 | 描述 |
|------|------|
| 持仓列表 | 显示所有持仓股票，包括成本价、现价、盈亏比例 |
| 资产配置 | 可视化展示现金、多头、空头的配置比例 |
| 业绩走势 | 归一化净值曲线（基准值=100），直观展示投资业绩 |
| 累计收益 | 使用时间加权收益率（TWR）计算，排除出入金影响 |
| 最大回撤 | 实时计算并展示历史最大回撤 |

**数据来源**：系统连接Supabase数据库，自动同步您在券商的交易记录和持仓数据。

**隐私保护**：所有数字均以百分比形式展示，不显示任何绝对金额。

---

### 二、投资笔记（Investment Memos）

**记录投资思考**，让每一次决策都有迹可循。

| 功能 | 描述 |
|------|------|
| 创建笔记 | 密码保护的笔记创建功能，自动生成日期标题 |
| 持仓快照 | 创建笔记时自动附加当天的持仓快照和资产配置 |
| 笔记列表 | 双栏卡片布局，类似小红书风格，美观易浏览 |
| 笔记详情 | 完整展示笔记内容和创建时的持仓状态 |

**使用场景**：
- 记录买入/卖出某只股票的理由
- 记录对市场的判断和预期
- 复盘过去的投资决策

---

### 三、投资照镜子（AI Trade Analysis）

**AI驱动的交易分析**，让每一笔交易都成为学习的机会。

这是系统最核心的创新功能。每天早上9:15，系统会自动分析您昨天的所有交易，并通过邮件发送分析报告。

| 功能 | 描述 |
|------|------|
| 自动分析 | 每日9:15自动分析前一天的交易记录 |
| 个性化反馈 | 基于您的投资笔记和播客内容，检测交易是否与您的投资原则一致 |
| 引用来源 | 分析结果附带引用来源，标明参考了哪些笔记或播客内容 |
| 历史记录 | 所有分析结果保存在数据库，可随时回顾 |
| 追问对话 | 在分析详情页可以继续追问投资顾问，进行深度讨论 |

**分析维度**：
1. 交易合理性分析（是否符合投资哲学）
2. 与过往原则的一致性检查
3. 交易理由评估（您填写的交易理由是否合理）
4. 潜在风险提示
5. 改进建议

**示例分析**：
> "这笔交易仅涉及约2万港币，直接违反了你在投资笔记中设定的'5万以下不做T'的原则。这种微操作会消耗你的认知带宽，却无法对整体组合产生实质性贡献。"

---

### 四、每日提醒系统（Daily Alerts）

**主动推送重要信息**，让您不错过任何关键动态。

每天早上9:15，系统会发送两封邮件：

**邮件一：持仓波动与新闻**
| 内容 | 描述 |
|------|------|
| 大幅波动股票 | 涨跌幅超过5%的持仓股票 |
| 相关新闻 | 持仓股票的最新公告和新闻 |
| A股公告 | 通过东方财富API获取A股公告 |
| 港股/美股新闻 | 通过多个数据源获取相关新闻 |

**邮件二：交易分析报告**
- 昨日所有交易的详细分析
- AI投资顾问的个性化反馈
- 引用您的投资笔记和播客内容

---

### 五、自动化定时任务

系统运行多个定时任务，确保数据始终最新：

| 任务 | 时间 | 描述 |
|------|------|------|
| 价格更新 | 每日7:00 AM | 获取所有持仓股票的最新价格 |
| 净值计算 | 每日7:00 AM | 计算当日净值并保存快照 |
| 备用更新 | 每日9:00 AM | 如果7:00任务失败，使用缓存数据重试 |
| 每日提醒 | 每日9:15 AM | 发送波动提醒和交易分析邮件 |

---

### 六、数据保护机制

系统内置多重数据校验，确保数据质量：

| 保护机制 | 描述 |
|----------|------|
| 价格波动校验 | 单只股票价格变化超过95%时拒绝写入 |
| 汇率范围校验 | USD/CNY必须在5-10之间，HKD/CNY必须在0.7-1.2之间 |
| 汇率变化校验 | 汇率变化超过20%时拒绝更新 |
| 净值变化校验 | 净值变化超过95%时拒绝保存快照 |
| 首次价格校验 | 新股票价格必须在0.01-100000范围内 |

---

## 技术架构

| 层级 | 技术栈 |
|------|--------|
| 前端 | React 19 + Tailwind CSS 4 + shadcn/ui |
| 后端 | Express + tRPC 11 |
| 数据库 | Supabase (PostgreSQL) |
| AI服务 | Manus LLM API + PIP投资顾问项目 |
| 定时任务 | Node.js Cron |
| 部署 | Manus托管平台 |

---

## 设计理念

**北欧极简主义**：浅灰色背景、黑色无衬线字体、柔和的蓝粉色点缀、充足的留白空间。

**隐私优先**：所有数据展示均使用比例和百分比，不暴露任何绝对金额。即使他人看到您的屏幕，也无法知道您的具体资产规模。

**过程即奖励**：系统名称来源于投资哲学——投资的过程本身就是奖励，而不仅仅是最终的收益。通过记录、分析、反思，让每一次投资决策都成为成长的机会。

---

## 适用人群

- **认真对待投资的个人投资者**：希望系统化管理投资组合
- **有投资哲学的投资者**：希望AI帮助检查交易是否符合自己的原则
- **注重隐私的投资者**：不希望暴露具体资产规模
- **喜欢复盘的投资者**：希望记录和回顾投资决策

---

## 未来规划

- [ ] 添加投资组合与主要指数的相关性分析
- [ ] 添加夏普比率等风险调整收益指标
- [ ] 添加交易评分功能，记录对AI分析的认可度
- [ ] 添加历史交易回顾，按股票筛选分析历史
- [ ] 添加数据质量日报，统计每日数据更新情况

---

*由 Manus AI 协助开发*
